from app.models import AuditLog, db
from datetime import datetime

def log_action(user_id, action):
    audit = AuditLog(user_id=user_id, action=action, timestamp=datetime.utcnow())
    db.session.add(audit)
    db.session.commit()

def get_all_logs():
    logs = AuditLog.query.order_by(AuditLog.timestamp.desc()).all()
    return [{
        "id": log.id,
        "user_id": log.user_id,
        "action": log.action,
        "timestamp": log.timestamp
    } for log in logs]
