import os
from werkzeug.utils import secure_filename
from app.models import Document, db
from datetime import datetime
from flask import current_app

UPLOAD_FOLDER = 'uploads/'

def save_document(file, user_id, doc_type):
    filename = secure_filename(file.filename)
    filepath = os.path.join(UPLOAD_FOLDER, filename)
    os.makedirs(UPLOAD_FOLDER, exist_ok=True)
    file.save(filepath)

    document = Document(
        user_id=user_id,
        type=doc_type,
        filepath=filepath,
        status="pending",
        upload_date=datetime.utcnow()
    )
    db.session.add(document)
    db.session.commit()
    return {"message": "Document uploaded successfully"}, 201

def get_all_documents():
    documents = Document.query.all()
    return [{
        "id": d.id,
        "user_id": d.user_id,
        "type": d.type,
        "upload_date": d.upload_date,
        "status": d.status,
        "filepath": d.filepath
    } for d in documents]

def update_document_status(doc_id, status):
    document = Document.query.get(doc_id)
    if not document:
        return {"message": "Document not found"}, 404
    document.status = status
    db.session.commit()
    return {"message": f"Document {status}"}, 200
