from app.models import ForgeryReport, db
from datetime import datetime

def report_forgery(data, user_id):
    new_report = ForgeryReport(
        document_id=data["document_id"],
        reported_by=user_id,
        reason=data["reason"],
        status="pending",
        report_date=datetime.utcnow()
    )
    db.session.add(new_report)
    db.session.commit()
    return {"message": "Forgery report submitted"}, 201

def get_all_reports():
    reports = ForgeryReport.query.all()
    return [{
        "id": r.id,
        "document_id": r.document_id,
        "reported_by": r.reported_by,
        "reason": r.reason,
        "status": r.status,
        "report_date": r.report_date
    } for r in reports]

def update_report_status(report_id, status):
    report = ForgeryReport.query.get(report_id)
    if not report:
        return {"message": "Report not found"}, 404
    report.status = status
    db.session.commit()
    return {"message": f"Report {status}"}
