from models import Document, ForgeryReport, db
from sqlalchemy import func
from datetime import datetime, timedelta

from models.upload_model import Upload
from app import db
from flask import jsonify


def weekly_upload_stats():
    one_week_ago = datetime.utcnow() - timedelta(days=7)
    result = db.session.query(
        func.date(Document.upload_date),
        func.count(Document.id)
    ).filter(Document.upload_date >= one_week_ago).group_by(func.date(Document.upload_date)).all()

    return [{"date": str(row[0]), "count": row[1]} for row in result]



def get_document_type_distribution():
    result = db.session.query(
        Upload.document_type,
        func.count(Upload.id)
    ).group_by(Upload.document_type).all()

    data = [{"type": doc_type, "count": count} for doc_type, count in result]
    return jsonify(data)

def get_weekly_uploads():
    today = datetime.utcnow().date()
    start_date = today - timedelta(days=6)

    result = db.session.query(
        func.date(Upload.upload_date),
        func.count(Upload.id)
    ).filter(
        Upload.upload_date >= start_date
    ).group_by(func.date(Upload.upload_date)).all()

    formatted = [{"date": str(date), "count": count} for date, count in result]
    return jsonify(formatted)


def status_summary():
    total = Document.query.count()
    verified = Document.query.filter_by(status="verified").count()
    rejected = Document.query.filter_by(status="rejected").count()
    pending = total - verified - rejected
    return {
        "total": total,
        "verified": verified,
        "rejected": rejected,
        "pending": pending
    }
