from app.models import Settings, db

def get_settings():
    settings = Settings.query.first()
    if settings:
        return {"review_threshold": settings.review_threshold}
    return {"review_threshold": 0}

def update_settings(data):
    settings = Settings.query.first()
    if not settings:
        settings = Settings()
    settings.review_threshold = data.get("review_threshold", 0)
    db.session.add(settings)
    db.session.commit()
    return {"message": "Settings updated"}
