from app.models import User, db
from werkzeug.security import generate_password_hash, check_password_hash
from flask_jwt_extended import create_access_token
from datetime import timedelta

def register_user(data):
    if User.query.filter((User.email == data['email']) | (User.username == data['username'])).first():
        return {"message": "User already exists"}, 400

    hashed_password = generate_password_hash(data['password'])
    new_user = User(
        username=data['username'],
        email=data['email'],
        password=hashed_password,
        role=data.get('role', 'user')
    )
    db.session.add(new_user)
    db.session.commit()
    return {"message": "User registered successfully"}, 201

def login_user(data):
    user = User.query.filter_by(email=data['email']).first()
    if user and check_password_hash(user.password, data['password']):
        access_token = create_access_token(identity={"id": user.id, "role": user.role}, expires_delta=timedelta(days=1))
        return {"token": access_token, "role": user.role, "username": user.username}, 200
    return {"message": "Invalid email or password"}, 401

def get_all_users():
    users = User.query.all()
    return [{
        "id": u.id,
        "username": u.username,
        "email": u.email,
        "role": u.role,
        "is_active": u.is_active
    } for u in users]

def toggle_user_status(user_id):
    user = User.query.get(user_id)
    if not user:
        return {"message": "User not found"}, 404
    user.is_active = not user.is_active
    db.session.commit()
    return {"message": "User status updated"}

def delete_user(user_id):
    user = User.query.get(user_id)
    if not user:
        return {"message": "User not found"}, 404
    db.session.delete(user)
    db.session.commit()
    return {"message": "User deleted"}
