import os
import hashlib

def is_elf_file(file_path):
    with open(file_path, 'rb') as f:
        magic = f.read(4)
    return magic == b'\x7fELF'

def sha256_hash(file_path):
    sha256 = hashlib.sha256()
    with open(file_path, 'rb') as f:
        for chunk in iter(lambda: f.read(4096), b""):
            sha256.update(chunk)
    return sha256.hexdigest()

def process_directory(directory):
    seen_hashes = set()
    for root, _, files in os.walk(directory):
        for file in files:
            try:
                file_path = os.path.join(root, file)
                if is_elf_file(file_path):
                    sha256 = sha256_hash(file_path)
                    if sha256 in seen_hashes:
                        os.remove(file_path)
                        print(f"Deleted duplicate file: {file_path}")
                    else:
                        seen_hashes.add(sha256)
                        new_file_name = f"{sha256}.elf"
                        new_file_path = os.path.join(root, new_file_name)
                        os.rename(file_path, new_file_path)
                        print(f"Renamed {file_path} to {new_file_path}")
                else:
                    os.remove(file_path)
                    print(f"Deleted non-ELF file: {file_path}")
            except Exception as e:
                print(f"Error processing file {file_path}: {e}")

if __name__ == "__main__":
    target_directory = "/path/to/your/directory"
    process_directory(target_directory)