import os
import shutil

def move_elf_files(src_directory, dst_directory):
    if not os.path.exists(dst_directory):
        os.makedirs(dst_directory)
    
    for root, _, files in os.walk(src_directory):
        for file in files:
            if file.endswith(".elf"):
                src_file_path = os.path.join(root, file)
                dst_file_path = os.path.join(dst_directory, file)
                
                try:
                    shutil.move(src_file_path, dst_file_path)
                    print(f"Moved {src_file_path} to {dst_file_path}")
                except Exception as e:
                    print(f"Error moving {src_file_path} to {dst_file_path}: {e}")

if __name__ == "__main__":
    src_directory = "/path/to/your/source/directory"
    dst_directory = "/path/to/your/destination/directory"
    move_elf_files(src_directory, dst_directory)