import os

def delete_large_elf_files(directory, size_limit=1048576):
    for root, dirs, files in os.walk(directory):
        for file in files:
            if file.endswith('.elf'):
                file_path = os.path.join(root, file)
                if os.path.getsize(file_path) > size_limit:
                    print(f"Deleting {file_path} (size: {os.path.getsize(file_path)} bytes)")
                    os.remove(file_path)

if __name__ == "__main__":
    directory_to_search = "/path/to/your/directory"
    delete_large_elf_files(directory_to_search)