import os
from elftools.elf.elffile import ELFFile
from elftools.common.exceptions import ELFError

def get_architecture(file_path):
    try:
        with open(file_path, 'rb') as f:
            elf = ELFFile(f)
            e_machine = elf['e_machine']
            if e_machine == 'EM_ARM':
                return 'ARM'
            elif e_machine == 'EM_386':
                return 'x86'
            elif e_machine == 'EM_X86_64':
                return 'x64'
            else:
                return None
    except ELFError:
        return None
    except Exception as e:
        print(f"Error reading {file_path}: {e}")
        return None

def process_directory(directory):
    for root, _, files in os.walk(directory):
        for file in files:
            if file.endswith(".elf"):
                file_path = os.path.join(root, file)
                arch = get_architecture(file_path)
                if arch not in ['ARM', 'x86', 'x64']:
                    try:
                        os.remove(file_path)
                        print(f"Deleted {file_path} with unsupported architecture {arch}")
                    except Exception as e:
                        print(f"Error deleting {file_path}: {e}")
                        os.remove(file_path)

if __name__ == "__main__":
    target_directory = "/path/to/your/directory"  
    process_directory(target_directory)