import os
import subprocess

def check_elf_type(file_path):
    try:
        
        result = subprocess.run(['file', file_path], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        output = result.stdout.decode('utf-8')
        if 'dynamically linked' in output:
            return 'dynamically linked'
        elif 'statically linked' in output:
            return 'statically linked'
        else:
            return 'unknown'
    except Exception as e:
        print(f"Error checking file type for {file_path}: {e}")
        return 'error'

def process_elf_files(directory):
    for root, dirs, files in os.walk(directory):
        for file in files:
            if file.endswith('.elf'):
                file_path = os.path.join(root, file)
                elf_type = check_elf_type(file_path)
                if elf_type == 'statically linked':
                    print(f"Deleting statically linked ELF file: {file_path}")
                    os.remove(file_path)
                elif elf_type == 'dynamically linked':
                    print(f"Keeping dynamically linked ELF file: {file_path}")
                else:
                    print(f"Unknown or error type for file: {file_path}")
                    os.remove(file_path)

if __name__ == "__main__":
    import argparse

    parser = argparse.ArgumentParser(description="Recursively check and delete statically linked ELF files.")
    parser.add_argument("directory", type=str, help="The target directory to check ELF files.")

    args = parser.parse_args()
    target_directory = args.directory

    if not os.path.isdir(target_directory):
        print(f"The provided directory does not exist: {target_directory}")
    else:
        process_elf_files(target_directory)