import os
import shutil
from elftools.elf.elffile import ELFFile

def get_elf_architecture(file_path):
    try:
        with open(file_path, 'rb') as f:
            elf = ELFFile(f)
            arch = elf.get_machine_arch()
        return arch
    except Exception as e:
        print(f"Error reading ELF file {file_path}: {e}")
        return "<unknown>"

def sanitize_directory_name(name):
    
    return "".join(c if c not in r'\/:*?"<>|' else "_" for c in name)

def process_directory(directory):
    for root, _, files in os.walk(directory):
        for file in files:
            file_path = os.path.join(root, file)
            if is_elf_file(file_path):
                arch = get_elf_architecture(file_path)
                sanitized_arch = sanitize_directory_name(arch)
                arch_dir = os.path.join(directory, sanitized_arch if sanitized_arch != "<unknown>" else "others")
                if not os.path.exists(arch_dir):
                    os.makedirs(arch_dir)
                shutil.move(file_path, os.path.join(arch_dir, file))
                print(f"Moved {file_path} to {arch_dir}")

def is_elf_file(file_path):
    try:
        with open(file_path, 'rb') as f:
            magic = f.read(4)
        return magic == b'\x7fELF'
    except Exception as e:
        print(f"Error reading file {file_path}: {e}")
        return False

if __name__ == "__main__":
    target_directory = "/path/to/your/directory"
    process_directory(target_directory)