# README

## Overview

This dataset accompanies the article *"Signal Conditioning System for Analog Processing of Dynamic Light Scattering Signals"* and includes processed data and the corresponding Jupyter Notebook for signal analysis. The data represents voltage signals obtained from a Maxwell demon-based signal generator and acquired through an analog conditioning system.

The notebook performs key analysis steps such as:
- Histogram generation
- Gaussian fitting
- Power spectral analysis
- Digital notch filtering (60 Hz and harmonics)
- Signal-to-noise ratio (SNR) and Shannon entropy calculations

## Instructions

To use this dataset:

1. Install Python (we recommend using [Anaconda](https://www.anaconda.com/) for convenience).
2. Open a terminal or command prompt.
3. Launch Jupyter Notebook by typing `jupyter notebook` and hitting Enter.
4. Open the file `data_processing_paper.ipynb`.
5. Run each cell in order to reproduce the data analysis and visualizations presented in the associated paper.

All processing functions are self-contained within the notebook.

## Contact

For questions regarding this dataset, please contact:

**David A. Miranda**  
Universidad Industrial de Santander  
Email: dalemir@uis.edu.co
